USE BD_Air_France;

IF OBJECT_ID ('dbo.T_pilote_pil','U') IS NOT NULL
    DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID ('dbo.T_compagnie_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_compagnie_cmp;
GO

CREATE TABLE T_compagnie_cmp
(
cmp_comp   VARCHAR(4) PRIMARY KEY, 
cmp_pays   CHAR(3), 
cmp_nom    VARCHAR(15), 
pil_chef   VARCHAR(6)
);
GO

INSERT INTO T_compagnie_cmp VALUES ('AF',   'fr', 'Air France',  'PL-2');
INSERT INTO T_compagnie_cmp VALUES ('SING', 'sn', 'Singapore AL','PL-6');
INSERT INTO T_compagnie_cmp VALUES ('CAST', 'fr', 'Castanet AL', 'PL-10');

CREATE TABLE T_pilote_pil
(
pil_brevet        INT IDENTITY PRIMARY KEY, 
pil_prenom        VARCHAR(15) NOT NULL, 
pil_nom           VARCHAR(15) NOT NULL, 
pil_embauche      DATE        NOT NULL, 
pil_fct           CHAR(3)     NOT NULL, 
pil_salaire       DECIMAL(7,2), 
cmp_comp          VARCHAR(4)  REFERENCES T_compagnie_cmp (cmp_comp), 
pil_responsable   VARCHAR(6));

-- insertions des lignes

DECLARE @i INT =1;
WHILE (@i < 10000)
BEGIN
   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Pierre','Filloux', '20080708', 'CDB', 5700, 'AF', NULL);

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Romaric','Benech', '20100905', 'PIL', 3400, 'AF','PL-2');

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable) 
   VALUES ('Vincent','Gindre', '20100413', 'PIL', 3600, 'AF','PL-1');  

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Aime','Giaconne', '20111224', 'CDB', 4200, 'AF','PL-2');

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Christian','Bec', '20111004', 'CDB', 4500, 'SING',NULL);

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Pierre','Calac', '20120416', 'PIL', 3000, 'SING','PL-6');

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Bruno','Bardon', '20091021', 'CDB', 5800, 'SING','PL-6');

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Patrice','Determe', '20071213', 'CDB', 7000, 'CAST',NULL);

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Christian','Soutou', '20100402', 'PIL', 3800, 'CAST','PL-8');

   INSERT INTO T_pilote_pil (pil_prenom, pil_nom, pil_embauche, pil_fct, pil_salaire, cmp_comp , pil_responsable)
   VALUES ('Bernard','Duclerc', '20100406', 'PIL', 4700, 'CAST','PL-8');
   
   SET @i=@i+1;
END;
GO

select count(*) from T_pilote_pil;